/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.collector;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import moze_intel.projecte.api.mapper.arithmetic.IValueArithmetic;
import moze_intel.projecte.api.mapper.collector.IExtendedMappingCollector;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;
import moze_intel.projecte.emc.mappers.customConversions.json.ConversionGroup;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversion;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversionFile;

public class DumpToFileCollector<A extends IValueArithmetic<?>>
extends AbstractMappingCollector<NormalizedSimpleStack, Long, A> {
    public static String currentGroupName = "default";
    private final CustomConversionFile out = new CustomConversionFile();
    private final IExtendedMappingCollector<NormalizedSimpleStack, Long, A> inner;
    private final File file;

    public DumpToFileCollector(File f, IExtendedMappingCollector<NormalizedSimpleStack, Long, A> inner) {
        super(inner.getArithmetic());
        this.file = f;
        this.inner = inner;
    }

    @Override
    public void setValueFromConversion(int outnumber, NormalizedSimpleStack something, Map<NormalizedSimpleStack, Integer> ingredientsWithAmount) {
        this.inner.setValueFromConversion(outnumber, something, ingredientsWithAmount);
        if (something == null || ingredientsWithAmount.containsKey(null)) {
            return;
        }
        this.out.values.conversion.add(CustomConversion.getFor(outnumber, something, ingredientsWithAmount));
    }

    @Override
    public void addConversion(int outnumber, NormalizedSimpleStack output, Map<NormalizedSimpleStack, Integer> ingredientsWithAmount, A arithmeticForConversion) {
        this.inner.addConversion(outnumber, output, ingredientsWithAmount, arithmeticForConversion);
        if (output == null || ingredientsWithAmount.containsKey(null)) {
            return;
        }
        if (!this.out.groups.containsKey(currentGroupName)) {
            this.out.groups.put(currentGroupName, new ConversionGroup());
        }
        ConversionGroup group = this.out.groups.get(currentGroupName);
        group.conversions.add(CustomConversion.getFor(outnumber, output, ingredientsWithAmount));
    }

    @Override
    public void setValueBefore(NormalizedSimpleStack something, Long value) {
        this.inner.setValueBefore(something, value);
        if (something == null) {
            return;
        }
        this.out.values.setValueBefore.put(something, value);
    }

    @Override
    public void setValueAfter(NormalizedSimpleStack something, Long value) {
        this.inner.setValueAfter(something, value);
        if (something == null) {
            return;
        }
        this.out.values.setValueAfter.put(something, value);
    }

    @Override
    public void finishCollection() {
        try {
            this.out.write(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.inner.finishCollection();
    }
}

